DEBUG_MODE = True

def read_text(prompt):
    '''
    Wyświetla monit i czyta ciąg tekstu.
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Zwraca ciąg znaków zawierający tekst wprowadzony przez użytkownika.
    '''
    while True:  # pętla nieskończona
        try:
            result=input(prompt) # czytanie danych wejściowych
            # jeśli dotarliśmy do tego miejsca, to nie zgłoszono wyjątku
            # przerwanie działania pętli
            break
        except KeyboardInterrupt:
            # jeśli dotarliśmy do tego miejsca, to użytkownik nacisnął Ctrl + C
            print('Wprowadź tekst')
            if DEBUG_MODE:
                raise Exception('Przerwanie z klawiatury')

    # zwrócenie wyniku
    return result


def read_number(prompt,function):
    '''
    Wyświetla monit i wczytuje liczbę zmiennoprzecinkową
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    while True:  # pętla nieskończona
        try:
            number_text=read_text(prompt)            
            result=function(number_text) # czytanie wejścia
            # jeśli dotarliśmy do tego miejsca, to nie zgłoszono wyjątku
            # przerwanie działania pętli
            break
        except ValueError:
            # jeśli program dotarł do tego miejsca, to użytkownik wprowadził nieprawidłową liczbę
            print('Podaj liczbę ')

    # zwrócenie wyniku
    return result

def read_number_ranged(prompt, function, min_value, max_value):
    '''
    Wyświetla monit i wczytuje liczbę.
    min_value określa minimalną wartość (włącznie); 
    max_value określa wartość maksymalną (włącznie).
    Zgłasza wyjątek, jeśli max i min są podane odwrotnie
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    if min_value>max_value:
        # Jeśli program dotarł do tego miejsca, to parametry min_value i max_value 
        # zostały podane odwrotnie
        raise Exception('Wartość minimalna jest większa od wartości maksymalnej.')
    while True:  # pętla nieskończona
        result=read_number(prompt,function)
        if result<min_value:
            # Wprowadzona wartość jest za mała
            print('Ta liczba jest za mała.')
            print('Minimalna wartość to:', min_value)
            # Powtarzaj pętlę odczytu liczby
            continue 
        if result>max_value:
            # Wprowadzona wartość jest zbyt duża
            print('Ta liczba jest za duża')
            print('Maksymalna wartość to:', max_value)
            # Powtarzaj pętlę odczytu liczby
            continue
        # Jeśli program doszedł do tego miejsca, to liczba jest prawidłowa
        # przerwanie działania pętli
        break
    # zwrócenie wyniku
    return result

def read_float(prompt):
    '''
    Wyświetla monit i wczytuje liczbę zmiennoprzecinkową
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    return read_number(prompt,float)

def read_int(prompt):
    '''
    Wyświetla monit i wczytuje liczbę całkowitą.
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę całkowitą reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    return read_number(prompt,int)

def read_float_ranged(prompt, min_value, max_value):
    '''
    Wyświetla monit i wczytuje liczbę zmiennoprzecinkową
    min_value określa minimalną wartość (włącznie); 
    max_value określa wartość maksymalną (włącznie).
    Zgłasza wyjątek, jeśli max i min są podane odwrotnie
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę zmiennoprzecinkową reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    return read_number_ranged(prompt,float,min_value,max_value)

def read_int_ranged(prompt, min_value, max_value):
    '''
    Wyświetla monit i wczytuje liczbę całkowitą.
    min_value określa minimalną wartość (włącznie); 
    max_value określa wartość maksymalną (włącznie).
    Zgłasza wyjątek, jeśli max i min są podane odwrotnie
    Przerwania z klawiatury (Ctrl + C) są ignorowane.
    Nieprawidłowe liczby są odrzucane.
    Zwraca liczbę  reprezentującą wartość wprowadzoną przez użytkownika.
    '''
    return read_number_ranged(prompt,int,min_value,max_value)

